; file.asm
section .data
; wyrażenia używane do asemblacji warunkowej
	CREATE 		equ 	1
	OVERWRITE 	equ 	1
	APPEND 		equ 	1
	O_WRITE 	equ 	1
	READ 		equ 	1
	O_READ 		equ 	1
	DELETE 		equ 	1
			
; symbole wywołań systemowych
    NR_read  	equ 	0 
    NR_write 	equ 	1 
    NR_open 	equ 	2 
    NR_close 	equ 	3
    NR_lseek 	equ 	8 
    NR_create 	equ 	85
    NR_unlink 	equ 	87

; flagi tworzenia i stanu
	O_CREAT 	equ 	00000100q  
    O_APPEND 	equ 	00002000q

; tryb dostępu 
    O_RDONLY 	equ 	000000q 
    O_WRONLY 	equ 	000001q 
    O_RDWR 		equ 	000002q

; tryb tworzenia (uprawnienia)
    S_IRUSR 	equ 	00400q  ; uprawnienie do odczytu przez użytkownika
    S_IWUSR 	equ 	00200q 	; uprawnienie do zapisu przez użytkownika
 
    NL	  		equ		0xa					
    bufferlen  	equ 	64
   
    fileName db 	"testfile.txt",0
    FD 		 dq 	0	; deskryptor pliku

    text1	 db 	"1. Witam... wszystkich!",NL,0
    len1     dq 	$-text1-1                  ; usuwamy 0
    text2    db 	"2. Tu jestem!",NL,0
    len2     dq 	$-text2-1                   ; usuwamy 0
    text3    db 	"3. Żyję i mam się dobrze!",NL,0
    len3     dq 	$-text3-1                   ; usuwamy 0
    text4    db 	"Adios !!!",NL,0
    len4     dq 	$-text4-1

    error_Create 	db "Błąd podczas tworzenia pliku",NL,0
    error_Close 	db "Błąd podczas zamykania pliku",NL,0
    error_Write 	db "Błąd podczas zapisywania pliku",NL,0
    error_Open 		db "Błąd podczas otwierania pliku",NL,0
    error_Append 	db "Błąd podczas dołączania do pliku",NL,0
    error_Delete 	db "Błąd podczas usuwania pliku",NL,0
    error_Read 		db "Błąd podczas odczytywania pliku",NL,0
    error_Print 	db "Błąd podczas wypisywania łańcucha",NL,0
    error_Position 	db "Błąd podczas ustawiania pozycji w pliku",NL,0
        
    success_Create 	db "Utworzono i otwarto plik",NL,0
    success_Close 	db "Zamknięto plik",NL,NL,0
    success_Write 	db "Zapisano plik",NL,0
    success_Open 	db "Otwarto plik do odczytu/zapisu/aktualizacji",NL,0
    success_Append 	db "Otworzono plik do dołączania",NL,0
    success_Delete 	db "Usunięto plik",NL,0
    success_Read 	db "Odczytano plik",NL,0
    success_Position db "Ustawiono pozycję w pliku",NL,0
    
section .bss							
    buffer resb bufferlen
section .text							
	global main						
main:
	push rbp
	mov  rbp,rsp
%IF CREATE
; TWORZYMY I OTWIERAMY PLIK, A NASTĘPNIE ZAMYKAMY GO ----------------------------------
; tworzymy i otwieramy plik
    mov 	rdi, fileName
    call 	createFile
    mov 	qword [FD], rax ; zapisujemy deskryptor

; pierwszy zapis do pliku
    mov 	rdi, qword [FD]
    mov 	rsi, text1
    mov 	rdx, qword [len1]
    call 	writeFile
    
; zamykamy plik
    mov 	rdi, qword [FD]
    call 	closeFile
%ENDIF
%IF OVERWRITE
; OTWIERAMY I NADPISUJEMY PLIK, A NASTĘPNIE ZAMYKAMY GO ------------------------------
; otwieramy plik 
   	mov 	rdi, fileName 
    call 	openFile  
    mov 	qword [FD], rax ; zapisujemy deskryptor
    
; drugi zapis do pliku: NADPISANIE!
    mov 	rdi, qword [FD]
    mov 	rsi, text2
    mov 	rdx, qword [len2]
    call 	writeFile    

; zamykamy plik
    mov 	rdi, qword [FD]
    call 	closeFile    
%ENDIF
%IF APPEND
; OTWIERAMY PLIK I DOŁĄCZAMY DO NIEGO DANE, A NASTĘPNIE ZAMYKAMY GO -------------------
; otwieramy plik do dołączania
    mov 	rdi, fileName 
    call 	appendFile  
    mov 	qword [FD], rax ; zapisujemy deskryptor
    
; trzeci zapis do pliku: DOŁĄCZANIE!
    mov 	rdi, qword [FD]
    mov 	rsi, text3
    mov 	rdx, qword [len3]
    call 	writeFile       

; zamykamy plik
    mov 	rdi, qword [FD]
    call 	closeFile 
%ENDIF
%IF O_WRITE
; OTWIERAMY PLIK I NADPISUJEMY GO Z PRZESUNIĘCIEM, A NASTĘPNIE ZAMYKAMY GO ----------
; otwieramy plik do zapisu
    mov 	rdi, fileName 
    call 	openFile  
    mov 	qword [FD], rax ; zapisujemy deskryptor

; ustawiamy pozycję w pliku
	mov 	rdi, qword[FD]
	mov 	rsi, qword[len2] ; przesunięcie do tego miejsca
	mov 	rdx, 0
	call 	positionFile    

; zapisujemy z przesunięciem
	mov 	rdi, qword[FD]
   	mov 	rsi, text4
    mov 	rdx, qword [len4]
    call 	writeFile 

; zamykamy plik
    mov 	rdi, qword [FD]
    call 	closeFile 
%ENDIF
%IF READ
; OTWIERAMY PLIK I CZYTAMY Z NIEGO DANE, A NASTĘPNIE ZAMYKAMY GO ---------------------
; otwieramy plik do odczytu
    mov 	rdi, fileName 
    call 	openFile  
    mov 	qword [FD], rax ; zapisujemy deskryptor pliku
      
; czytamy z pliku
    mov 	rdi, qword [FD]
    mov 	rsi, buffer
    mov 	rdx, bufferlen    
    call 	readFile
    mov 	rdi,rax
    call 	printString

; zamykamy plik
    mov 	rdi, qword [FD]
    call 	closeFile 
%ENDIF
%IF O_READ
; OTWIERAMY PLIK I CZYTAMY Z NIEGO Z PRZESUNIĘCIEM, A NASTĘPNIE ZAMYKAMY GO ---------
; otwieramy plik do odczytu
    mov 	rdi, fileName 
    call 	openFile  
    mov 	qword [FD], rax ; zapisujemy deskryptor pliku 

; ustawiamy pozycję w pliku
	mov 	rdi, qword[FD]
	mov 	rsi, qword[len2]		; pomijamy pierwszy wiersz
	mov 	rdx, 0
	call 	positionFile          

; czytamy z pliku
    mov 	rdi, qword [FD]
    mov 	rsi, buffer
    mov 	rdx, 10    ; liczba znaków do odczytania
    call 	readFile
    mov 	rdi,rax
    call 	printString

; zamykamy plik
    mov 	rdi, qword [FD]
    call 	closeFile 
%ENDIF
%IF DELETE
; USUWAMY PLIK --------------------------------------------------   
; usuwamy plik
    mov 	rdi, fileName
    call 	deleteFile                                      
%ENDIF


leave
ret

; FUNKCJE MANIPULUJĄCE PLIKAMI -----------------------------------
;-----------------------------------------------------------------
global readFile
readFile:
    mov 	rax, NR_read
    syscall                         ; rax zawiera liczbę odczytanych znaków
    cmp 	rax, 0 
    jl 		readerror
    mov 	byte [rsi+rax],0	; dodajemy końcowe zero do łańcucha
    mov 	rax, rsi
    
    mov 	rdi, success_Read
	push	rax		; rejestr zapisywany przez wywołującego
    call 	printString
	pop		rax		; rejestr zapisywany przez wywołującego
    ret
readerror:
        mov 	rdi, error_Read 
        call 	printString
        ret  
;-----------------------------------------------------------------
global deleteFile
deleteFile:
    mov 	rax, NR_unlink
    syscall
    cmp 	rax, 0 
    jl 		deleteerror
    mov 	rdi, success_Delete
    call 	printString
    ret
deleteerror:
        mov 	rdi, error_Delete 
        call 	printString
        ret  
;-----------------------------------------------------------------
global appendFile
appendFile:
    mov 	rax, NR_open 
    mov 	rsi,  O_RDWR|O_APPEND
    syscall
    cmp 	rax, 0 
    jl 		appenderror
    mov 	rdi, success_Append
	push	rax		; rejestr zapisywany przez wywołującego
    call 	printString
	pop		rax		; rejestr zapisywany przez wywołującego
    ret
appenderror:
        mov 	rdi, error_Append 
        call 	printString
        ret  
;-----------------------------------------------------------------
global openFile
openFile:
    mov 	rax, NR_open 
    mov 	rsi, O_RDWR
    syscall
    cmp 	rax, 0 
    jl 		openerror
    mov 	rdi, success_Open
	push	rax		; rejestr zapisywany przez wywołującego
    call 	printString
	pop		rax		; rejestr zapisywany przez wywołującego
    ret
openerror:
        mov 	rdi, error_Open 
        call 	printString
        ret  
;-----------------------------------------------------------------
global writeFile
writeFile:
    mov 	rax, NR_write
    syscall
    cmp 	rax, 0 
    jl 		writeerror
    mov 	rdi, success_Write
    call 	printString
    ret
writeerror:
        mov 	rdi, error_Write 
        call 	printString
        ret

;-----------------------------------------------------------------
global positionFile
positionFile:
    mov 	rax, NR_lseek
    syscall
    cmp 	rax, 0 
    jl 		positionerror
    mov 	rdi, success_Position
    call 	printString
    ret
positionerror:
        mov 	rdi, error_Position 
        call 	printString
        ret    
;-----------------------------------------------------------------
global closeFile
closeFile:
    mov 	rax, NR_close
    syscall
    cmp 	rax, 0 
    jl 		closeerror
    mov 	rdi, success_Close
    call 	printString
    ret
closeerror:
        mov 	rdi, error_Close 
        call 	printString
        ret    
;-----------------------------------------------------------------
global createFile
createFile:
    mov 	rax, NR_create
    mov 	rsi, S_IRUSR |S_IWUSR 
    syscall
    cmp 	rax, 0 			; deskryptor pliku w rax
    jl 		createerror
    mov 	rdi, success_Create
	push	rax		; rejestr zapisywany przez wywołującego
    call 	printString
	pop		rax		; rejestr zapisywany przez wywołującego
    ret
createerror:
        mov 	rdi, error_Create 
        call 	printString
        ret    

; WYPISYWANIE INFORMACJI ZWROTNYCH
;-----------------------------------------------------------------
global printString
printString:

; Liczymy znaki 
    mov 	r12, rdi
    mov 	rdx, 0 
strLoop:
    cmp 	byte [r12], 0
    je 		strDone
    inc 	rdx                 ; długość w rdx
    inc 	r12
    jmp 	strLoop
strDone:
    cmp 	rdx, 0              ; brak łańcucha (długość 0)
    je 		prtDone
    mov 	rsi,rdi
    mov 	rax, 1 
    mov 	rdi, 1
    syscall
prtDone:

    ret
